import { BrowserRouter as Router, Routes, Route, Navigate } from "react-router-dom";
import { QueryClient, QueryClientProvider } from "@tanstack/react-query";
import { Toaster } from "@/components/ui/toaster";
import { AuthProvider } from "./contexts/AuthContext";
import LoginPage from "./pages/LoginPage";
import RegisterPage from "./pages/RegisterPage";
import DashboardPage from "./pages/DashboardPage";
import MadrasahPage from "./pages/MadrasahPage";
import GuruPage from "./pages/GuruPage";
import SiswaPage from "./pages/SiswaPage";
import KaryawanPage from "./pages/KaryawanPage";
import AlumniPage from "./pages/AlumniPage";
import ProtectedRoute from "./components/ProtectedRoute";

const queryClient = new QueryClient();

export default function App() {
  return (
    <QueryClientProvider client={queryClient}>
      <AuthProvider>
        <Router>
          <div className="min-h-screen bg-gray-50">
            <Routes>
              <Route path="/login" element={<LoginPage />} />
              <Route path="/register" element={<RegisterPage />} />
              <Route path="/" element={<Navigate to="/dashboard" replace />} />
              <Route
                path="/dashboard"
                element={
                  <ProtectedRoute>
                    <DashboardPage />
                  </ProtectedRoute>
                }
              />
              <Route
                path="/madrasah"
                element={
                  <ProtectedRoute requireSuperAdmin>
                    <MadrasahPage />
                  </ProtectedRoute>
                }
              />
              <Route
                path="/guru"
                element={
                  <ProtectedRoute>
                    <GuruPage />
                  </ProtectedRoute>
                }
              />
              <Route
                path="/siswa"
                element={
                  <ProtectedRoute>
                    <SiswaPage />
                  </ProtectedRoute>
                }
              />
              <Route
                path="/karyawan"
                element={
                  <ProtectedRoute>
                    <KaryawanPage />
                  </ProtectedRoute>
                }
              />
              <Route
                path="/alumni"
                element={
                  <ProtectedRoute>
                    <AlumniPage />
                  </ProtectedRoute>
                }
              />
            </Routes>
            <Toaster />
          </div>
        </Router>
      </AuthProvider>
    </QueryClientProvider>
  );
}
