import { api } from "encore.dev/api";
import { SQLDatabase } from "encore.dev/storage/sqldb";

const db = SQLDatabase.named("madrasah");

export interface CreateKaryawanRequest {
  madrasah_id: string;
  nip?: string;
  nama_lengkap: string;
  tempat_lahir?: string;
  tanggal_lahir?: string;
  jenis_kelamin?: string;
  agama?: string;
  alamat?: string;
  no_telepon?: string;
  email?: string;
  pendidikan_terakhir?: string;
  jabatan?: string;
  bagian?: string;
  tanggal_masuk?: string;
  status_kepegawaian?: string;
}

export interface Karyawan {
  id: string;
  madrasah_id: string;
  nip: string;
  nama_lengkap: string;
  tempat_lahir: string;
  tanggal_lahir: string;
  jenis_kelamin: string;
  agama: string;
  alamat: string;
  no_telepon: string;
  email: string;
  pendidikan_terakhir: string;
  jabatan: string;
  bagian: string;
  tanggal_masuk: string;
  status_kepegawaian: string;
}

// Creates a new karyawan
export const createKaryawan = api<CreateKaryawanRequest, Karyawan>(
  { expose: true, method: "POST", path: "/karyawan" },
  async (req) => {
    const karyawan = await db.queryRow<Karyawan>`
      INSERT INTO karyawan (madrasah_id, nip, nama_lengkap, tempat_lahir, tanggal_lahir, jenis_kelamin, agama, alamat, 
                           no_telepon, email, pendidikan_terakhir, jabatan, bagian, tanggal_masuk, status_kepegawaian)
      VALUES (${req.madrasah_id}, ${req.nip || ""}, ${req.nama_lengkap}, ${req.tempat_lahir || ""}, 
              ${req.tanggal_lahir || null}, ${req.jenis_kelamin || ""}, ${req.agama || ""}, ${req.alamat || ""}, 
              ${req.no_telepon || ""}, ${req.email || ""}, ${req.pendidikan_terakhir || ""}, ${req.jabatan || ""}, 
              ${req.bagian || ""}, ${req.tanggal_masuk || null}, ${req.status_kepegawaian || ""})
      RETURNING id, madrasah_id, nip, nama_lengkap, tempat_lahir, tanggal_lahir, jenis_kelamin, agama, alamat, 
                no_telepon, email, pendidikan_terakhir, jabatan, bagian, tanggal_masuk, status_kepegawaian
    `;
    
    return karyawan!;
  }
);
