import { api } from "encore.dev/api";
import { SQLDatabase } from "encore.dev/storage/sqldb";

const db = SQLDatabase.named("madrasah");

export interface CreateGuruRequest {
  madrasah_id: string;
  nip?: string;
  nama_lengkap: string;
  tempat_lahir?: string;
  tanggal_lahir?: string;
  jenis_kelamin?: string;
  agama?: string;
  alamat?: string;
  no_telepon?: string;
  email?: string;
  pendidikan_terakhir?: string;
  mata_pelajaran?: string;
  status_kepegawaian?: string;
  tanggal_masuk?: string;
}

export interface Guru {
  id: string;
  madrasah_id: string;
  nip: string;
  nama_lengkap: string;
  tempat_lahir: string;
  tanggal_lahir: string;
  jenis_kelamin: string;
  agama: string;
  alamat: string;
  no_telepon: string;
  email: string;
  pendidikan_terakhir: string;
  mata_pelajaran: string;
  status_kepegawaian: string;
  tanggal_masuk: string;
}

// Creates a new guru
export const createGuru = api<CreateGuruRequest, Guru>(
  { expose: true, method: "POST", path: "/guru" },
  async (req) => {
    const guru = await db.queryRow<Guru>`
      INSERT INTO guru (madrasah_id, nip, nama_lengkap, tempat_lahir, tanggal_lahir, jenis_kelamin, agama, alamat, 
                       no_telepon, email, pendidikan_terakhir, mata_pelajaran, status_kepegawaian, tanggal_masuk)
      VALUES (${req.madrasah_id}, ${req.nip || ""}, ${req.nama_lengkap}, ${req.tempat_lahir || ""}, 
              ${req.tanggal_lahir || null}, ${req.jenis_kelamin || ""}, ${req.agama || ""}, ${req.alamat || ""}, 
              ${req.no_telepon || ""}, ${req.email || ""}, ${req.pendidikan_terakhir || ""}, ${req.mata_pelajaran || ""}, 
              ${req.status_kepegawaian || ""}, ${req.tanggal_masuk || null})
      RETURNING id, madrasah_id, nip, nama_lengkap, tempat_lahir, tanggal_lahir, jenis_kelamin, agama, alamat, 
                no_telepon, email, pendidikan_terakhir, mata_pelajaran, status_kepegawaian, tanggal_masuk
    `;
    
    return guru!;
  }
);
